/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4604;
import net.minecraft.class_5365;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPCGlobal;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.compat.IPModInfoChecking;
import qouteall.imm_ptl.core.compat.iris_compatibility.ExperimentalIrisPortalRenderer;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisCompatibilityPortalRenderer;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisPortalRenderer;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.render.MyGameRenderer;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.Helper;

public abstract class PortalRenderer {
    public static final Event<Predicate<Portal>> PORTAL_RENDERING_PREDICATE = EventFactory.createArrayBacked(Predicate.class, listeners -> portal -> {
        for (Predicate listener : listeners) {
            if (listener.test(portal)) continue;
            return false;
        }
        return true;
    });
    public static final class_310 client = class_310.method_1551();
    private static boolean fabulousWarned = false;

    public abstract void onBeforeTranslucentRendering(Matrix4f var1);

    public abstract void onAfterTranslucentRendering(Matrix4f var1);

    public abstract void onHandRenderingEnded();

    public void onBeforeHandRendering(Matrix4f modelView) {
    }

    public abstract void prepareRendering();

    public abstract void finishRendering();

    public abstract void renderPortalInEntityRenderer(Portal var1);

    public abstract boolean replaceFrameBufferClearing();

    protected List<Portal> getPortalsToRender(Matrix4f modelView) {
        Supplier<class_4604> frustumSupplier = Helper.cached(() -> {
            class_4604 frustum = new class_4604(modelView, RenderSystem.getProjectionMatrix());
            class_243 cameraPos = PortalRenderer.client.field_1773.method_19418().method_19326();
            frustum.method_23088(cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350);
            return frustum;
        });
        ObjectArrayList renderables = new ObjectArrayList();
        class_638 world = PortalRenderer.client.field_1687;
        assert (world != null);
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals((class_1937)world);
        for (Portal globalPortal : globalPortals) {
            if (PortalRenderer.shouldSkipRenderingPortal(globalPortal, frustumSupplier)) continue;
            renderables.add((Object)globalPortal);
        }
        world.method_18112().forEach(e -> {
            Portal portal;
            if (e instanceof Portal && !PortalRenderer.shouldSkipRenderingPortal(portal = (Portal)e, frustumSupplier)) {
                renderables.add((Object)portal);
            }
        });
        class_243 cameraPos = CHelper.getCurrentCameraPos();
        renderables.sort(Comparator.comparingDouble(e -> e.getDistanceToNearestPointInPortal(cameraPos)));
        return renderables;
    }

    private static boolean shouldSkipRenderingPortal(Portal portal, Supplier<class_4604> frustumSupplier) {
        class_4604 frustum;
        Portal outerPortal;
        if (!portal.isPortalValid()) {
            return true;
        }
        if (!portal.isVisible() && IPGlobal.maxPortalLayer != 0) {
            return true;
        }
        if (RenderStates.getRenderedPortalNum() >= IPGlobal.portalRenderLimit) {
            return true;
        }
        class_243 cameraPos = TransformationManager.getIsometricAdjustedCameraPos();
        if (!portal.isRoughlyVisibleTo(cameraPos)) {
            return true;
        }
        if (PortalRendering.isRendering() && (outerPortal = PortalRendering.getRenderingPortal()).cannotRenderInMe(portal)) {
            return true;
        }
        double distance = portal.getDistanceToNearestPointInPortal(cameraPos);
        if (distance > PortalRenderer.getRenderRange()) {
            return true;
        }
        if (IPCGlobal.earlyFrustumCullingPortal && distance > 0.1 && !(frustum = frustumSupplier.get()).method_23093(portal.getThinBoundingBox())) {
            return true;
        }
        if (PortalRendering.isInvalidRecursionRendering(portal)) {
            return true;
        }
        boolean predicateTest = ((Predicate)PORTAL_RENDERING_PREDICATE.invoker()).test(portal);
        return !predicateTest;
    }

    public static double getRenderRange() {
        double outerPortalScale;
        double range = PortalRenderer.client.field_1690.method_38521() * 16;
        if (RenderStates.isLaggy || IPGlobal.reducedPortalRendering) {
            range = 16.0;
        }
        if (PortalRendering.getPortalLayer() > 1) {
            range /= (double)PortalRendering.getPortalLayer();
        }
        if (PortalRendering.getPortalLayer() >= 1 && (outerPortalScale = PortalRendering.getRenderingPortal().getScale()) > 2.0) {
            range *= outerPortalScale;
            range = Math.min(range, 512.0);
        }
        return range;
    }

    protected final void renderPortalContent(Portal portal) {
        if (PortalRendering.getPortalLayer() > PortalRendering.getMaxPortalLayer()) {
            return;
        }
        class_638 newWorld = ClientWorldLoader.getWorld(portal.getDestDim());
        PortalRendering.onBeginPortalWorldRendering();
        int renderDistance = PortalRenderer.getPortalRenderDistance(portal);
        this.invokeWorldRendering(new WorldRenderInfo.Builder().setWorld(newWorld).setCameraPos(PortalRendering.getRenderingCameraPos()).setCameraTransformation(portal.getAdditionalCameraTransformation()).setOverwriteCameraTransformation(false).setDescription(portal.getDiscriminator()).setRenderDistance(renderDistance).setDoRenderHand(false).setEnableViewBobbing(true).setDoRenderSky(!portal.isFuseView()).build());
        PortalRendering.onEndPortalWorldRendering();
        GlStateManager._enableDepthTest();
        MyRenderHelper.restoreViewPort();
    }

    private static int getPortalRenderDistance(Portal portal) {
        int mcRenderDistance = PortalRenderer.client.field_1690.method_38521();
        if (portal.getScale() > 2.0) {
            double radiusBlocks = portal.getDestAreaRadiusEstimation() * 1.4;
            radiusBlocks = Math.min(radiusBlocks, 512.0);
            return Math.max((int)(radiusBlocks / 16.0), mcRenderDistance);
        }
        if (IPGlobal.reducedPortalRendering) {
            return mcRenderDistance / 3;
        }
        return mcRenderDistance;
    }

    public void invokeWorldRendering(WorldRenderInfo worldRenderInfo) {
        MyGameRenderer.renderWorldNew(worldRenderInfo, Runnable::run);
    }

    @Nullable
    public static Matrix4f getPortalTransformation(Portal portal) {
        Matrix4f rot = PortalRenderer.getPortalRotationMatrix(portal);
        Matrix4f mirror = portal instanceof Mirror ? TransformationManager.getMirrorTransformation(portal.getNormal()) : null;
        Matrix4f scale = PortalRenderer.getPortalScaleMatrix(portal);
        return PortalRenderer.combineNullable(rot, PortalRenderer.combineNullable(mirror, scale));
    }

    @Nullable
    public static Matrix4f getPortalRotationMatrix(Portal portal) {
        if (portal.getRotation() == null) {
            return null;
        }
        Quaternionf rot = portal.getRotation().toMcQuaternion();
        rot.conjugate();
        return rot.get(new Matrix4f());
    }

    @Nullable
    public static Matrix4f combineNullable(@Nullable Matrix4f a, @Nullable Matrix4f b) {
        return Helper.combineNullable(a, b, (m1, m2) -> {
            m1.mul((Matrix4fc)m2);
            return m1;
        });
    }

    @Nullable
    public static Matrix4f getPortalScaleMatrix(Portal portal) {
        if (PortalRenderer.shouldApplyScaleToModelView(portal)) {
            float v = (float)(1.0 / portal.getScale());
            return new Matrix4f().scale(v, v, v);
        }
        return null;
    }

    public static boolean shouldApplyScaleToModelView(Portal portal) {
        return portal.hasScaling() && portal.isFuseView();
    }

    public void onBeginIrisTranslucentRendering(Matrix4f modelView) {
    }

    public static void switchToCorrectRenderer() {
        if (PortalRendering.isRendering()) {
            return;
        }
        if (class_310.method_1551().field_1690.method_42534().method_41753() == class_5365.field_25429 && !fabulousWarned) {
            fabulousWarned = true;
            CHelper.printChat((class_2561)class_2561.method_43471((String)"imm_ptl.fabulous_warning"));
        }
        IPModInfoChecking.checkShaderpack();
        if (IrisInterface.invoker.isIrisPresent() && IrisInterface.invoker.isShaders()) {
            if (IPCGlobal.experimentalIrisPortalRenderer) {
                PortalRenderer.switchRenderer(ExperimentalIrisPortalRenderer.instance);
                return;
            }
            switch (IPGlobal.renderMode) {
                case normal: {
                    PortalRenderer.switchRenderer(IrisPortalRenderer.instance);
                    break;
                }
                case compatibility: {
                    PortalRenderer.switchRenderer(IrisCompatibilityPortalRenderer.instance);
                    break;
                }
                case debug: {
                    PortalRenderer.switchRenderer(IrisCompatibilityPortalRenderer.debugModeInstance);
                    break;
                }
                case none: {
                    PortalRenderer.switchRenderer(IPCGlobal.rendererDummy);
                }
            }
            return;
        }
        switch (IPGlobal.renderMode) {
            case normal: {
                PortalRenderer.switchRenderer(IPCGlobal.rendererUsingStencil);
                break;
            }
            case compatibility: {
                PortalRenderer.switchRenderer(IPCGlobal.rendererUsingFrameBuffer);
                break;
            }
            case debug: {
                PortalRenderer.switchRenderer(IPCGlobal.rendererDebug);
                break;
            }
            case none: {
                PortalRenderer.switchRenderer(IPCGlobal.rendererDummy);
            }
        }
    }

    private static void switchRenderer(PortalRenderer renderer) {
        if (IPCGlobal.renderer != renderer) {
            Helper.log("switched to renderer " + String.valueOf(renderer.getClass()));
            IPCGlobal.renderer = renderer;
            if (IrisInterface.invoker.isShaders()) {
                IrisInterface.invoker.reloadPipelines();
            }
        }
    }
}

